﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace Brian_LaRue
{
    public partial class Home : System.Web.UI.Page, System.Web.UI.ICallbackEventHandler
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            // Resister the call back events
            ClientScriptManager cm = Page.ClientScript;
            String cbReference = cm.GetCallbackEventReference(this, "arg", "ReceiveServerData", "");
            String callbackScript = "function CallServer(arg, context) {" + cbReference + "; }";
            cm.RegisterClientScriptBlock(this.GetType(), "CallServer", callbackScript, true);
        }

        public void RaiseCallbackEvent(String eventArgument)
        {

        }

        /// <summary>
        /// returns the Client callback result
        /// </summary>
        /// <returns></returns>
        public string GetCallbackResult()
        {
            return "Server is Online.";
        }

        /// <summary>
        /// Insert Coin button click event, redirects to Insert Coin Page
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        protected void btnInsertCoin_Click(object sender, EventArgs e)
        {
            Response.Redirect("InsertCoin.aspx");
        }
    }
}